/*
 * Decompiled with CFR 0.152.
 */
package com.smardec.mousegestures.test;

import com.smardec.mousegestures.MouseGestures;
import com.smardec.mousegestures.MouseGesturesListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TestFrame
extends JFrame {
    private MouseGestures mouseGestures = new MouseGestures();
    private JLabel statusLabel = new JLabel("Mouse gesture: ");

    public static void main(String[] args) {
        TestFrame frame = new TestFrame();
        frame.show();
    }

    public TestFrame() {
        this.setDefaultCloseOperation(3);
        this.setTitle("Mouse Gestures Test Frame");
        this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/mousegestures/test/img/logo.gif")).getImage());
        this.initSize();
        this.getContentPane().setLayout(new BorderLayout());
        this.initControls();
        this.initStatusBar();
        this.initMouseGestures();
    }

    private void initSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = new Dimension(640, 480);
        if (size.height > screenSize.height) {
            size.height = screenSize.height;
        }
        if (size.width > screenSize.width) {
            size.width = screenSize.width;
        }
        this.setSize(size);
        this.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
    }

    private void initControls() {
        JCheckBox jCheckBoxButton1 = new JCheckBox("Right button");
        jCheckBoxButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestFrame.this.mouseGestures.setMouseButton(4);
            }
        });
        JCheckBox jCheckBoxButton2 = new JCheckBox("Middle button");
        jCheckBoxButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestFrame.this.mouseGestures.setMouseButton(8);
            }
        });
        JCheckBox jCheckBoxButton3 = new JCheckBox("Left button");
        jCheckBoxButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestFrame.this.mouseGestures.setMouseButton(16);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jCheckBoxButton1);
        buttonGroup.add(jCheckBoxButton2);
        buttonGroup.add(jCheckBoxButton3);
        jCheckBoxButton1.setSelected(true);
        JPanel jPanel = new JPanel(new GridLayout(4, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        jPanel.add(new JLabel("Select mouse button used for gestures handling."));
        jPanel.add(jCheckBoxButton1);
        jPanel.add(jCheckBoxButton2);
        jPanel.add(jCheckBoxButton3);
        this.getContentPane().add((Component)jPanel, "North");
    }

    private void initStatusBar() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.add(this.statusLabel);
        this.getContentPane().add((Component)jPanel, "South");
    }

    private void initMouseGestures() {
        this.mouseGestures = new MouseGestures();
        this.mouseGestures.addMouseGesturesListener(new MouseGesturesListener(){

            public void gestureMovementRecognized(String currentGesture) {
                TestFrame.this.setGestureString(this.addCommas(currentGesture));
            }

            public void processGesture(String gesture) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                TestFrame.this.setGestureString("");
            }

            private String addCommas(String gesture) {
                StringBuffer stringBuffer = new StringBuffer();
                int i = 0;
                while (i < gesture.length()) {
                    stringBuffer.append(gesture.charAt(i));
                    if (i != gesture.length() - 1) {
                        stringBuffer.append(",");
                    }
                    ++i;
                }
                return stringBuffer.toString();
            }
        });
        this.mouseGestures.start();
    }

    private void setGestureString(String gesture) {
        this.statusLabel.setText("Mouse gesture: " + gesture);
    }
}

