// https://allatori.com/doc.html#android-studio

plugins {
    id("com.android.application")
    id("org.jetbrains.kotlin.android") version "1.8.10"
}

android {
    namespace = "com.allatori.kotlin"
    compileSdk = 34

    defaultConfig {
        applicationId = "com.allatori.kotlin"
        minSdk = 24
        targetSdk = 34
        versionCode = 1
        versionName = "1.0"

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
    }

    buildTypes {
        release {
            isMinifyEnabled = false
            proguardFiles(getDefaultProguardFile("proguard-android-optimize.txt"), "proguard-rules.pro")
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_17
        targetCompatibility = JavaVersion.VERSION_17
    }
    buildFeatures {
        viewBinding = true
    }

    //
    // Allatori for applications
    //
    applicationVariants.all {
        val variant = this
        javaCompileProvider.get().doLast {
            runAllatori(variant)
        }
    }
    //
    // Allatori for libraries
    //
/*
    libraryVariants.all {
        val variant = this
        javaCompileProvider.get().doLast {
            runAllatori(variant)
        }
    }
*/
}

dependencies {

    implementation("androidx.appcompat:appcompat:1.6.1")
    implementation("com.google.android.material:material:1.8.0")
    implementation("androidx.constraintlayout:constraintlayout:2.1.4")
    implementation("androidx.lifecycle:lifecycle-livedata-ktx:2.6.1")
    implementation("androidx.lifecycle:lifecycle-viewmodel-ktx:2.6.1")
    implementation("androidx.navigation:navigation-fragment:2.5.3")
    implementation("androidx.navigation:navigation-ui:2.5.3")
    testImplementation("junit:junit:4.13.2")
    androidTestImplementation("androidx.test.ext:junit:1.1.5")
    androidTestImplementation("androidx.test.espresso:espresso-core:3.5.1")
}


fun runAllatori(variant: com.android.build.gradle.api.ApplicationVariant) {
    println("Path to allatori.jar should be $rootDir/allatori/allatori.jar")
    println("Path to allatori.xml configuration file should be $projectDir/allatori.xml")

    val classesRoot = variant.javaCompileProvider.get().destinationDirectory.get()
    val kotlinRoot = "${buildDir}/tmp/kotlin-classes/${variant.name}"

    copy {
        from("$projectDir/allatori.xml")
        into("$classesRoot/../")
        expand(Pair("classesRoot", classesRoot),
                Pair("kotlinRoot", kotlinRoot),
                Pair("androidJar", "${android.sdkDirectory}/platforms/${android.compileSdkVersion}/android.jar"),
                Pair("classpathJars", variant.javaCompileProvider.get().classpath.asPath),
                Pair("logFile", "allatori-log.xml"))
        rename("allatori.xml", "allatori-expanded.xml")
    }

    File("$classesRoot-obfuscated").deleteRecursively()
    // Kotlin classes support
    File("$kotlinRoot-obfuscated").deleteRecursively()

    javaexec {
        mainClass.set("com.allatori.Obfuscate")
        classpath(files("$rootDir/allatori/allatori.jar"))
        args("$classesRoot/../allatori-expanded.xml")
    }

    File("$classesRoot").deleteRecursively()
    File("$classesRoot-obfuscated").renameTo(File("$classesRoot"))

    // Kotlin classes support
    if (File("$kotlinRoot-obfuscated").exists()) {
        File("$kotlinRoot").deleteRecursively()
        File("$kotlinRoot-obfuscated").renameTo(File("$kotlinRoot"))
    }
}
